<?php
do
{
	if (!preg_match('#X-vBMail-Mailinglist: (\d+)#', $this->headers, $matches))
	{
		// No matches
		break;
	}

	// Remove this temp header
	$this->headers = str_replace("X-vBMail-Mailinglist: $matches[1]" . $this->delimiter, '', $this->headers);

	if (!class_exists('VBMAIL'))
	{
		// We had no vBMail
		break;
	}

	if (!$mailinglist = VBMAIL::$cache['mailinglist'][$matches[1]])
	{
		// Invalid mailing list
		break;
	}

	if (!$mailinglist['smtp']['override'])
	{
		// We're not overriding the SMTP
		break;
	}

	$backup = $override = array();
	foreach ($mailinglist['smtp'] as $key => $val)
	{
		if ($key == 'override')
		{
			// Skip this
			continue;
		}

		if ($key != 'tls' AND !$val)
		{
			// Blank
			continue;
		}

		// Store backup
		$backup[$key] = $this->registry->options['smtp_' . $key];

		// Get rid of references
		unset($this->registry->options['smtp_' . $key]);

		// Override
		$override['smtp_' . $key] = $val;
	}

	$this->secure = $override['smtp_tls'];

	// Prior to 3.8 this was a radio button so SSL is 1
	if ($override['smtp_tls'] == 1)
	{
		$this->secure = 'ssl';
	}

	//since ('ssl' == 0) is true in php, we need to check for legacy 0 values as well
	//note that in the off change that somebody gets '0' into the system, this will
	//work just fine without conversion.
	else if ($override['smtp_tls'] === 0)
	{
		$this->secure = 'none';
	}

	$this->smtpHost = $override['smtp_host'];
	$this->smtpPort = (!empty($override['smtp_port']) ? intval($override['smtp_port']) : 25);	
	$this->smtpUser = $override['smtp_user'];
	$this->smtpPass = $override['smtp_pass'];

	foreach ($backup as $key => $val)
	{
		// Restore
		$this->registry->options['smtp_' . $key] = $backup[$key];
	}
}
while (false);
?>